/**
 * This package is the core of the jsPlumb Community Edition.
 *
 *
 * @packageDocumentation
 */

import {DotEndpointHandler} from "./endpoint/dot-endpoint"
import {BlankEndpointHandler} from "./endpoint/blank-endpoint"
import {RectangleEndpointHandler} from "./endpoint/rectangle-endpoint"

import {StraightConnector} from "./connector/straight-connector"

import { Connectors } from './connector/connectors'
import {EndpointFactory} from "./factory/endpoint-factory"

export * from "./constants"
export * from './params'
export * from "./callbacks"
export * from "./type-descriptors"

export * from "./core"
export * from "./defaults"
export * from './viewport'

export * from "./group/group"
export * from "./group/group-manager"

export * from "./component/component"

export * from "./connector/abstract-connector"
export * from "./connector/arc-segment"
export * from "./connector/connection-impl"
export * from "./connector/connectors"
export * from "./connector/straight-segment"

export * from './connector/straight-connector'

export * from "./selection/connection-selection"

export * from './endpoint/endpoint'
export * from './endpoint/endpoint-options'
export * from './factory/endpoint-factory'
export * from './endpoint/endpoints'
export * from './endpoint/dot-endpoint'
export * from './endpoint/rectangle-endpoint'
export * from './endpoint/blank-endpoint'

export * from "./selection/endpoint-selection"

export * from './source-selector'

export * from "./overlay/overlay"
export * from "./overlay/label-overlay"
export * from "./overlay/arrow-overlay"
export * from "./overlay/plain-arrow-overlay"
export * from "./overlay/diamond-overlay"
export * from "./overlay/custom-overlay"
export * from "./factory/overlay-factory"

export * from './router/router'

export * from "./factory/anchor-record-factory"
export * from './router/lightweight-router'

EndpointFactory.registerHandler(DotEndpointHandler)
EndpointFactory.registerHandler(RectangleEndpointHandler)
EndpointFactory.registerHandler(BlankEndpointHandler)

Connectors.register(StraightConnector.type, StraightConnector)


